// Optimized Vertex Shader
// Use flat interpolation for non‐interpolated values; reduce precision if acceptable

varying vec4 lmtexcoord;
varying vec4 color;
varying vec3 normalMat;
flat varying float labvalue;
flat varying float emissive;

#ifdef LEAVES
attribute vec4 mc_midTexCoord;
#endif

attribute vec4 mc_Entity;
#define diagonal3(m) vec3((m)[0].x, (m)[1].y, (m)[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + (m)[3].xyz)

// Include any common vertex functions and definitions
#include "/lib/vertex/main.glsl"

void main()
{

    const float lightmapMin = 8.0;
    const float lightmapMax = 255.0; // we tell a lil lie... should be 238.0
    vec2 lmNorm = clamp((gl_MultiTexCoord1.xy - lightmapMin) / (lightmapMax - lightmapMin), 0.0, 1.0);
    lmtexcoord = vec4(gl_MultiTexCoord0.xy, lmNorm);

    // Pass through color
    color = gl_Color;

    // Retrieve material properties based on entity id
    int entityCheck = int(mc_Entity.x);
    labvalue = getMaterialProperties(entityCheck).z;

    // Compute emissive using a conditional operator to reduce branch overhead
    emissive = (entityCheck >= 100 && entityCheck <= 355) ? pow(lmtexcoord.z, 8.0) : 0.0;

    // Pass the vertex normal (optionally, consider normalizing if needed)
    normalMat = gl_Normal;

    // Compute transformed position; note the conversion to a 3x3 matrix removes redundant translation
    vec3 position = (mat3(gl_ModelViewMatrix) * gl_Vertex.xyz) + gl_ModelViewMatrix[3].xyz;

#ifdef LEAVES
    // In the LEAVES variant, combine branch conditions to reduce divergence.
    bool applyWave = isFlower(entityCheck, (gl_MultiTexCoord0.t < mc_midTexCoord.t)) ||
                     isLeaves(entityCheck, (abs(position.z) < 64.0 && gl_MultiTexCoord1.y > 100.0));
    if (applyWave)
    {
        // computeWaveOffset should be inlined or optimized in its implementation.
        position = computeWaveOffset(position, cameraPosition, gl_Vertex, gl_MultiTexCoord1, gbufferModelView);
    }
#endif

    // Compute final clip-space position; if TAA is enabled, process accordingly
#if defined ENTITY && defined NO_ENTITY_TAA
    gl_Position = toClipSpace4(position);
#else
    gl_Position = taaFunc(toClipSpace4(position));
#endif
}
